#include <p30fxxxx.h>
#include <incap.h>

/********************************************************************
*    Function Name:  ConfigIntCapture2                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture2(unsigned int config)
{
    IFS0bits.IC2IF = 0;                     /* Clear IF bit */
    IPC1bits.IC2IP = (config &0x0007);      /* assigning Interrupt Priority
                                             to IPC Control REgister */
    IEC0bits.IC2IE = (config &0x0008) >> 3; /* assiging InputCapture Enable/
                                              Disable bit of IEC Register*/
}
